﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using DataAccess;
using Newtonsoft;
using Newtonsoft.Json;
using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml;
using System.Xml.Linq;
using Ext.Net;
using System.Collections.Generic;
using System.IO;
using System.Collections;
using System.Web.Script.Serialization;

using System.Xml.Xsl;
using ext = Ext.Net;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "REPSPI")]

public partial class reports_pi : System.Web.UI.Page
{
    //[DirectMethod(ShowMask = true, Msg="<span role='alert'>Please wait.</span>")]
    protected void ToCsv(object sender, EventArgs e)
    {
        //string builder
        StringBuilder sb = new StringBuilder();
        
        //date and filters header 
        sb.Append("\"Report Date\",\"From Date\",\"To Date\",\"Site1\",\"Site2\",\"Program\",\"Clinical Setting\",\"Primary Impairment\",\"Mechanism of Injury\",\"Gender\",\"Duty Status\" ");
        sb.Append(Environment.NewLine);
                
        sb.Append("\"" + DateTime.Now.ToString("MM/dd/yyyy hh:mm:ss") + "\"");
        sb.Append(",");
        //filters
        sb.Append("\"" + dfFromDate.SelectedDate.ToString("MM/dd/yyyy") + "\"");
        sb.Append(",");
        
        sb.Append("\"" + dfToDate.SelectedDate.ToString("MM/dd/yyyy") + "\"");
        sb.Append(",");
        
        //site 1
        sb.Append("\"" + cboPISite1.SelectedItem.Text + "\"");
        sb.Append(",");
        
        //site 2
        sb.Append("\"" + cboPISite2.SelectedItem.Text + "\"");
        sb.Append(",");
               
        //program
        sb.Append("\"" + cboPICPAType.SelectedItem.Text + "\"");
        sb.Append(",");

        //clinical setting
        sb.Append("\"" + cboReportClinicalSetting.SelectedItem.Text + "\"");
        sb.Append(",");
       
        //primary impairment
        sb.Append("\"" + cboReportImpairment.SelectedItem.Text + "\"");
        sb.Append(",");

        //mechanism of injury
        sb.Append("\"" + cboReportInjury.SelectedItem.Text + "\"");
        sb.Append(",");

        //gender
        sb.Append("\"" + cboReportGender.SelectedItem.Text + "\"");
        sb.Append(",");

        //duty status
        sb.Append("\"" + cboReportMilStatus.SelectedItem.Text + "\"");
        
        //instruments will be in the data so dont think they are needed here
               
        //end the row and add an empty row
        sb.Append(Environment.NewLine);
        sb.Append(Environment.NewLine);
        
        //all the raw scores
        CReportsPI pi = new CReportsPI();
        CDataConverter cdc = new CDataConverter();
        DataSet dsScoresAvg = pi.GetPopScoreAvgDS(Master);

        DataSet dsScoresAvgALL = pi.GetPopScoreAvgAllDS(Master, CDataUtils2.ToLong(cboPISite1.SelectedItem.Value));


        //build ds of sites
        //DataSet dsSite = new DataSet();
        DataTable dtSite = new DataTable();

        dtSite.Columns.Add("site_id");
        dtSite.Columns.Add("site_name");

        dtSite.Rows.Add(new object[] { CDataUtils2.ToLong(cboPISite1.SelectedItem.Value),
                                       cboPISite1.SelectedItem.Text});

        dtSite.Rows.Add(new object[] { CDataUtils2.ToLong(cboPISite2.SelectedItem.Value),
                                       cboPISite2.SelectedItem.Text});
        
        //get the sites selected in this report
       // DataSet dsSites = pi.GetPopSiteIDDS(Master);
       // DataTable dtSite = dsSites.Tables[0];
        foreach (DataRow drSite in dtSite.Rows)
        {  
            //columns
            //only if not none
            if(CDataUtils2.GetDSLongValue(drSite, "site_id") != -99)
            {
                sb.Append("\"Site\",\"Instrument\",\"Score\",\"Admission Avg\",\"Discharge Avg\",\"Avg Change\",\"Followup Avg\",\"Avg Length of Stay\"");
            }
            //   foreach (DataColumn dc in dt.Columns)
            //   {
            //      sb.Append("\"" + dc.ColumnName + "\",");
            // }

            //add a new line
            sb.Append(Environment.NewLine);

             //get the instruments selected in this report
            DataSet dsMIDS = pi.GetPopMIDDS(Master);
            DataTable dtMID = dsMIDS.Tables[0];

            foreach (DataRow drMID in dtMID.Rows)
            {
                DataSet ds = null;
                DataTable dt = null;
                                
                //all
                if (CDataUtils2.GetDSLongValue(drSite, "site_id") == -1)
                {
                
                    ds = GetSiteModuleAvgDS(dsScoresAvgALL,
                                            CDataUtils2.GetDSLongValue(drSite, "site_id"),
                                            CDataUtils2.GetDSLongValue(drMID, "MID")
                                             );

                    dt = ds.Tables[0];
                }
                //site
                else
                {
                    ds = GetSiteModuleAvgDS(dsScoresAvg,
                                                CDataUtils2.GetDSLongValue(drSite, "site_id"),
                                                CDataUtils2.GetDSLongValue(drMID, "MID")
                                                );

                    dt = ds.Tables[0];
                }

                 

                //do the rows
                foreach (DataRow dr in dt.Rows)
                {
                    //site
                    sb.Append("\"" + CDataUtils2.GetDSStringValue(drSite, "site_name") + "\"");
                    sb.Append(",");

                    //instrument
                    sb.Append("\"" + CDataUtils2.GetDSStringValue(dr, "module") + "\"");
                    sb.Append(",");

                    //string strO = dr["score_description"].ToString();

                    string strDescr = CDataUtils2.GetDSStringValue(dr, "score_description");
                    strDescr = HttpUtility.HtmlDecode(strDescr);
                    strDescr = strDescr.Replace("&amp;", "&");


                    //score
                    sb.Append("\"" + strDescr + "\"");
                    sb.Append(",");

                    //admission
                    sb.Append("\"" + CDataUtils2.GetDSStringValue(dr, "admission_average") + "\"");
                    sb.Append(",");

                    //discharge
                    sb.Append("\"" + CDataUtils2.GetDSStringValue(dr, "discharge_average") + "\"");
                    sb.Append(",");

                    //change
                    sb.Append("\"" + CDataUtils2.GetDSStringValue(dr, "average_change") + "\"");
                    sb.Append(",");

                    //followup
                    sb.Append("\"" + CDataUtils2.GetDSStringValue(dr, "followup_average") + "\"");
                    sb.Append(",");

                    //los
                    sb.Append("\"" + CDataUtils2.GetDSStringValue(dr, "average_los") + "\"");
                    sb.Append(",");

                    // for (int i = 0; i < dt.Columns.Count; i++)
                    // {
                    //     sb.Append("\"" + dr[i].ToString() + "\",");
                    //}

                    sb.Append(Environment.NewLine);
                }
                                
            }

            //double new line between sites
            sb.Append(Environment.NewLine);
        }




        //new line to end the report
        sb.Append(Environment.NewLine);

        //write the report
        HttpResponse r = HttpContext.Current.Response;
        r.Clear();
        r.ClearContent();
        r.ClearHeaders();
        r.Buffer = true;
        r.AddHeader("Content-Disposition", "attachment;filename=TBIPIReport_" + DateTime.Now.ToString("MMddyy") + ".csv");
        r.ContentType = "text/csv";
        r.Charset = "utf-8";
        r.Write(sb.ToString());
        r.End();

        /*

        string json = strScoresAvg;
        json = CHtmlRemoval.StripTagsRegexCompiled(json);

        StoreSubmitDataEventArgs eSubmit = new StoreSubmitDataEventArgs(json, null);
        XmlNode xml = eSubmit.Xml;

        this.Response.Clear();
        this.Response.ContentType = "application/vnd.ms-excel";
        this.Response.AddHeader("Content-Disposition", "attachment; filename=ProgramImprovement.xls");

        XslCompiledTransform xtExcel = new XslCompiledTransform();

        xtExcel.Load(Server.MapPath("Csv.xsl"));
        xtExcel.Transform(xml, null, this.Response.OutputStream);
        this.Response.End();*/

    }
        
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:7281 user closed the agg report criteria popup
    /// </summary>
    /// <param name="strGroupTypeID"></param>
    public bool RunReport(string strInstrumentJSON)
    {
        //date range is a must!
        DateTime dtFrom = dfFromDate.SelectedDate;
        DateTime dtTo = dfToDate.SelectedDate;
        if (dtFrom.Year == 1 ||
           dtTo.Year == 1 ||
           (dtFrom > dtTo))
        {
            Master.ShowSystemFeedback("Please select a valid from and to date.", "Error");
            return false;
        }

        //1 site is a must!
        if (cboPISite1.SelectedItem.Value == null )
        {
            Master.ShowSystemFeedback("Please select valid site!", "Error");
            return false;

        }

        //at least one instruemnt is a must
        //1 site is a must!
        if (strInstrumentJSON == "[]")
        {
            Master.ShowSystemFeedback("Please select at least one instrument!", "Error");
            return false;

        }
        
        //cpa type id
        long lCPATypeID = -1;
        if (cboPICPAType.SelectedItem.Value != null)
        {
            lCPATypeID = CDataUtils2.ToLong(cboPICPAType.SelectedItem.Value);
        }

        //clinical setting
        long lClinicalSetting = -1;
        if (cboReportClinicalSetting.SelectedItem.Value != null)
        {
            lClinicalSetting = CDataUtils2.ToLong(cboReportClinicalSetting.SelectedItem.Value);
        }

        //impairment
        long lImpairment = -1;
        if (cboReportImpairment.SelectedItem.Value != null)
        {
            lImpairment = CDataUtils2.ToLong(cboReportImpairment.SelectedItem.Value);
        }

        //injury
        long lInjury = -1;
        if (cboReportInjury.SelectedItem.Value != null)
        {
            lInjury = CDataUtils2.ToLong(cboReportInjury.SelectedItem.Value);
        }
 
        //gender
        string strGender = "-1";
        if (cboReportGender.SelectedItem.Value == "1")
        {
            strGender = "M";
        }
        if (cboReportGender.SelectedItem.Value == "2")
        {
            strGender = "F";
        }

        //military status
        long lMilStatus = CDataUtils2.ToLong(cboReportMilStatus.SelectedItem.Value);
        if (cboReportMilStatus.SelectedItem.Value != null)
        {
            lMilStatus = CDataUtils2.ToLong(cboReportMilStatus.SelectedItem.Value);
        }

        //build list of site ids
        string strSiteIDs = "";
        strSiteIDs = strSiteIDs + cboPISite1.SelectedItem.Value + ",";
        strSiteIDs = strSiteIDs + cboPISite2.SelectedItem.Value + ",";

        //if the second site is all, then pass neg 1 so we get all sites...
        if (cboPISite2.SelectedItem.Value == "-1")
        {
            strSiteIDs = "-1";
        }

        //load the population
        CReportsPI pi = new CReportsPI();
        pi.LoadPopulation(Master,
                          dtFrom,
                          dtTo,
                          lClinicalSetting,
                          Master.RegionID,
                          Master.SiteID,
                          lCPATypeID,
                          lImpairment,
                          lInjury,
                          strGender,
                          lMilStatus,
                          strSiteIDs);
        
        //load pop module for all selected modules 
        Dictionary<string, string>[] gpData = JSON.Deserialize<Dictionary<string, string>[]>(strInstrumentJSON);
        for (int i = 0; i < gpData.Count(); i++)
        {
            if (!String.IsNullOrEmpty(gpData[i]["MID"]))
            {
                long lMID = CDataUtils2.ToLong(gpData[i]["MID"]);
                pi.LoadPopModule(Master, lMID);
            }
        }

        //clear the root
        if (tpnlSite1.Root != null)
        {
            if (tpnlSite1.Root.Count > 0)
            {
                tpnlSite1.Root.Clear();
            }
        }

        //add a new root
        Ext.Net.Node ndRoot1;
        ndRoot1 = new Node() { Text = "" };
        ndRoot1.Expanded = true;
        ndRoot1.EmptyChildren = true;
        tpnlSite1.Root.Add(ndRoot1);


        //clear the root
        if (tpnlSite2.Root != null)
        {
            if (tpnlSite2.Root.Count > 0)
            {
                tpnlSite2.Root.Clear();
            }
        }

        //add a new root
        Ext.Net.Node ndRoot2;
        ndRoot2 = new Node() { Text = "" };
        ndRoot2.Expanded = true;
        ndRoot2.EmptyChildren = true;
        tpnlSite2.Root.Add(ndRoot2);
        
        //site one title and tree
        CDataConverter cdc = new CDataConverter();
        DataSet dsScoresAvg = pi.GetPopScoreAvgDS(Master);
        tpnlSite1.Title = cboPISite1.SelectedItem.Text;
        long lSite1 = CDataUtils2.ToLong(cboPISite1.SelectedItem.Value);
        LoadTree(dsScoresAvg, 
                ndRoot1, 
                lSite1, 
                cboPISite1.SelectedItem.Text,
                gpData);

        //site 2 title and tree
        tpnlSite2.Title = cboPISite2.SelectedItem.Text;

        
        long lSite2 = CDataUtils2.ToLong(cboPISite2.SelectedItem.Value);
        if (lSite2 != -1) //-1 = all sites
        {
            LoadTree(dsScoresAvg,
                    ndRoot2,
                    lSite2,
                    cboPISite2.SelectedItem.Text,
                    gpData);
        }
        else
        {
            DataSet dsScoresAvgALL = pi.GetPopScoreAvgAllDS(Master,lSite1);
            LoadTree(dsScoresAvgALL,
                     ndRoot2,
                     lSite2,
                     cboPISite2.SelectedItem.Text,
                     gpData);

        }

        //close the popup
        wndLoadPIPop.Close();
            
        //hide site 2 if not needed
        if (cboPISite2.SelectedItem.Value == null || cboPISite2.SelectedItem.Value == "-99")
        {
            //hide site 2
      //      tpnlSite2.Height = 0;
            tpnlSite2.Hide();
            
            //resize site 1
      //      tpnlSite1.Height = 415;

        }
        else
        {
            //show site 2
        //    tpnlSite2.Height = 210;
            tpnlSite2.Show();
            
            //resize site 1
            //tpnlSite1.Height = 210;
                        
        }

        //render the site 1 tree
        tpnlSite1.Render(tpnlSite1, RenderMode.Replace);

        //render the site 2 tree
        tpnlSite2.Render(tpnlSite2, RenderMode.Replace);

        //container update will cause changes to show
        pnlbodyPI.Update();

        btnPIExport.Enable();

        return true;

    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="lSiteID"></param>
    /// <returns></returns>
    protected DataSet GetSiteModuleAvgDS(DataSet dsScoresAvg, long lSiteID, long lMID)
    {
        DataSet ds = new DataSet();
        DataTable dt = new DataTable();

        dt.Columns.Add("site_id");
        dt.Columns.Add("mid");
        dt.Columns.Add("series");
        dt.Columns.Add("admission_average");
        dt.Columns.Add("discharge_average");
        dt.Columns.Add("average_change");
        dt.Columns.Add("followup_average");
        dt.Columns.Add("average_los");
        dt.Columns.Add("score_description");
        dt.Columns.Add("site_name");
        dt.Columns.Add("module");

        string strsite_id = Convert.ToString(lSiteID);
        string strmid = Convert.ToString(lMID);
        string strseries = "";
        string stradmission_average = "";
        string strdischarge_average = "";
        string straverage_change = "";
        string strfollowup_average = "";
        string straverage_los = "";
        string strscore_description = "";
        string strSiteName = "";
        string strModule = "";

        //raw average data
        CReportsPI pi = new CReportsPI();
       // DataSet dsScoresAvg = pi.GetPopScoreAvgDS(Master);

        //series only: 0 1 2 3 4 5 6 7 8 9 etc...
        DataSet dsSeries = pi.GetPopModuleSeriesDS(Master, lSiteID, lMID);

        if (dsSeries == null)
        {
            return null;
        }

        foreach (DataTable dtSeries in dsSeries.Tables)
        {
            foreach (DataRow drSeries in dtSeries.Rows)
            {
                //one series to work with: 0 1 2 3 4...
                long lSeries = CDataUtils2.GetDSLongValue(drSeries, "SERIES");

                //keep the series
                strseries = Convert.ToString(lSeries);

                long lCnt = 0;

                //loop and get the data for this site, mid and series only
                foreach (DataTable dtScore in dsScoresAvg.Tables)
                {
                    foreach (DataRow drScore in dtScore.Rows)
                    {
                        //mathes site
                        long lSID = CDataUtils2.GetDSLongValue(drScore, "SITE_ID");
                        if (lSID == lSiteID || lSiteID == -1)
                        {
                            //matches mid
                            long lMD = CDataUtils2.GetDSLongValue(drScore, "MID");
                            if (lMD == lMID)
                            {
                                //score type
                                string strScoreType = CDataUtils2.GetDSStringValue(drScore, "SCORE_TYPE");

                                //series
                                long lMatchSeries = CDataUtils2.GetDSLongValue(drScore, "SERIES");

                                //match
                                if (lMatchSeries == lSeries)
                                {
                                    //keep the description
                                    strscore_description = CDataUtils2.GetDSStringValue(drScore, "description");

                                    strModule = CDataUtils2.GetDSStringValue(drScore, "module");
                                    strSiteName = CDataUtils2.GetDSStringValue(drScore, "site_name");

                                    if (strScoreType == "ADMISSION")
                                    {
                                        stradmission_average = CDataUtils2.GetDSStringValue(drScore, "average_score");
                                        if (straverage_los == "")
                                        {
                                            straverage_los = CDataUtils2.GetDSStringValue(drScore, "average_los");
                                        }

                                        lCnt++;   
                                    }

                                    if (strScoreType == "DISCHARGE")
                                    {
                                        strdischarge_average = CDataUtils2.GetDSStringValue(drScore, "average_score");
                                        if (straverage_los == "")
                                        {
                                            straverage_los = CDataUtils2.GetDSStringValue(drScore, "average_los");
                                        }

                                        lCnt++;   
                                    }

                                    if (strScoreType == "FOLLOWUP")
                                    {
                                        strfollowup_average = CDataUtils2.GetDSStringValue(drScore, "average_score");
                                        if (straverage_los == "")
                                        {
                                            straverage_los = CDataUtils2.GetDSStringValue(drScore, "average_los");
                                        }

                                        lCnt++;   
                                    }

                                    //string straverage_change = "";
                                 
                                    if (lCnt >= 3)
                                    {
                                        //no need to press on we found 3....
                                        break;
                                    }
                                    
                                }//mid match
                            }//site match
                        }//row loop
                    }//table loop


                    straverage_change = "";
                    if(!String.IsNullOrEmpty(stradmission_average))
                    {
                        if(!String.IsNullOrEmpty(strdischarge_average))
                        {
                            double dblChange = Convert.ToDouble(strdischarge_average) - Convert.ToDouble(stradmission_average);
                            straverage_change = Convert.ToString(Math.Round(dblChange,2));
                        }
                    }
                                        

                    //at the end of the loop add a new record
                    //write the record
                    dt.Rows.Add(new object[] { strsite_id, 
                                               strmid,
                                               strseries,
                                               stradmission_average,
                                               strdischarge_average,
                                               straverage_change,
                                               strfollowup_average,
                                               straverage_los,
                                               strscore_description,
                                               strSiteName,
                                               strModule});

                    //clear the values
                    strseries = "";
                    stradmission_average = "";
                    strdischarge_average = "";
                    straverage_change = "";
                    strfollowup_average = "";
                    straverage_los = "";
                    strscore_description = "";
                    strSiteName = "";
                    strModule = "";

                }
            }
        }
        ds.Tables.Add(dt);
                
        return ds;
    }

    /// <summary>
    /// laod the tree
    /// </summary>
    protected void LoadTree(DataSet dsScoresAvg, 
                            Ext.Net.Node ndRoot, 
                            long lSiteID, 
                            string strSiteName,
                            Dictionary<string, string>[] gpData)
    {
        CDataConverter cdc = new CDataConverter();  
        CReportsPI pi = new CReportsPI();
            
        //mid admission_average discharge_average average_change average_los
        for (int i = 0; i < gpData.Count(); i++)
        {
            long lMID = CDataUtils2.ToLong(gpData[i]["MID"]);
            string strModule = gpData[i]["MODULE"];

            //new MODULE node under nd
            Ext.Net.Node ndMID = new Ext.Net.Node();
            ndMID.Expanded = false;
            ndMID.EmptyChildren = false;

            //start with +/-
            ndMID.Leaf = false;

            ndMID.Icon = Ext.Net.Icon.BulletBlack;
            
            //module name
            ConfigItem ciScoreMidDescr = new ConfigItem("score_description", strModule);
            ndMID.CustomAttributes.Add(ciScoreMidDescr);

            //series zero
            Ext.Net.Node ndSeries0 = new Ext.Net.Node();
                             
            //get data for this site and mid and add it to the module node
            int nSeriesZeroCount = 0;
            int nLeafCount = 0;
            DataSet ds = GetSiteModuleAvgDS(dsScoresAvg, lSiteID, lMID);
            if (ds != null)
            {
                foreach (DataTable table in ds.Tables)
                {
                    foreach (DataRow row in table.Rows) //loop over the scores
                    {
                        long lSeries = CDataUtils2.GetDSLongValue(row, "series");
                        if (lSeries == 0)
                        {
                            nSeriesZeroCount++;

                            //score leaf
                            ndMID.Expanded = false;
                            ndMID.EmptyChildren = false;
                            ndMID.Leaf = false; //end of the line

                            ndMID.Icon = Ext.Net.Icon.BulletBlack;

                       //     ConfigItem ciScoreDescr = new ConfigItem("score_description", CDataUtils2.GetDSStringValue(row, "score_description"));
                       //     ndMID.CustomAttributes.Add(ciScoreDescr);

                            ConfigItem ciAdmissionAvg = new ConfigItem("admission_average", CDataUtils2.GetDSStringValue(row, "admission_average"));
                            ndMID.CustomAttributes.Add(ciAdmissionAvg);

                            ConfigItem ciDischargeAvg = new ConfigItem("discharge_average", CDataUtils2.GetDSStringValue(row, "discharge_average"));
                            ndMID.CustomAttributes.Add(ciDischargeAvg);

                            ConfigItem ciAverageChange = new ConfigItem("average_change", CDataUtils2.GetDSStringValue(row, "average_change"));
                            ndMID.CustomAttributes.Add(ciAverageChange);

                            ConfigItem ciFollowupAvg = new ConfigItem("followup_average", CDataUtils2.GetDSStringValue(row, "followup_average"));
                            ndMID.CustomAttributes.Add(ciFollowupAvg);

                            ConfigItem ciLOS = new ConfigItem("average_los", CDataUtils2.GetDSStringValue(row, "average_los"));
                            ndMID.CustomAttributes.Add(ciLOS);

                            //set the node id
                            //nd.NodeID = CDataUtils2.GetDSStringValue(row, "MID");

                            //add items to the tree/grid
                            //ConfigItem ciMID = new ConfigItem("mid", CDataUtils2.GetDSStringValue(row, "mid"));
                            //nd.CustomAttributes.Add(ciMID);
                            //ConfigItem ciSeries = new ConfigItem("series", CDataUtils2.GetDSStringValue(row, "series"));
                            //nd.CustomAttributes.Add(ciSeries);
                            //ConfigItem ciSiteID = new ConfigItem("site_id", CDataUtils2.GetDSStringValue(row, "site_id"));
                            //nd.CustomAttributes.Add(ciSiteID);                           

                        }
                        else
                        {
                            nLeafCount++;

                            //score leaf
                            Ext.Net.Node ndSub = new Ext.Net.Node();
                            ndSub.Expanded = false;
                            ndSub.EmptyChildren = false;
                            ndSub.Leaf = true; //end of the line

                            ndSub.Icon = Ext.Net.Icon.BulletBlack;

                            string strDescr = CDataUtils2.GetDSStringValue(row, "score_description");
                            strDescr = HttpUtility.HtmlDecode(strDescr);
                            strDescr = strDescr.Replace("&amp;", "&");

                            ConfigItem ciScoreDescr = new ConfigItem("score_description", strDescr);
                            ndSub.CustomAttributes.Add(ciScoreDescr);

                            ConfigItem ciAdmissionAvg = new ConfigItem("admission_average", CDataUtils2.GetDSStringValue(row, "admission_average"));
                            ndSub.CustomAttributes.Add(ciAdmissionAvg);

                            ConfigItem ciDischargeAvg = new ConfigItem("discharge_average", CDataUtils2.GetDSStringValue(row, "discharge_average"));
                            ndSub.CustomAttributes.Add(ciDischargeAvg);

                            ConfigItem ciAverageChange = new ConfigItem("average_change", CDataUtils2.GetDSStringValue(row, "average_change"));
                            ndSub.CustomAttributes.Add(ciAverageChange);

                            ConfigItem ciFollowupAvg = new ConfigItem("followup_average", CDataUtils2.GetDSStringValue(row, "followup_average"));
                            ndSub.CustomAttributes.Add(ciFollowupAvg);

                            ConfigItem ciLOS = new ConfigItem("average_los", CDataUtils2.GetDSStringValue(row, "average_los"));
                            ndSub.CustomAttributes.Add(ciLOS);

                            //set the node id
                            //nd.NodeID = CDataUtils2.GetDSStringValue(row, "MID");

                            //add items to the tree/grid
                            //ConfigItem ciMID = new ConfigItem("mid", CDataUtils2.GetDSStringValue(row, "mid"));
                            //nd.CustomAttributes.Add(ciMID);
                            //ConfigItem ciSeries = new ConfigItem("series", CDataUtils2.GetDSStringValue(row, "series"));
                            //nd.CustomAttributes.Add(ciSeries);
                            //ConfigItem ciSiteID = new ConfigItem("site_id", CDataUtils2.GetDSStringValue(row, "site_id"));
                            //nd.CustomAttributes.Add(ciSiteID);

                            ndMID.Children.Add(ndSub);
                        }
                        //ndMID.Children.Add(ndSub);
            
                    }//row loop
                }//table loop
            }//ds not null

            if (nLeafCount < 1)
            {
                ndMID.Leaf = true;
            }
            else
            {
                ndMID.Leaf = false;
            }

    //        if (nSeriesZeroCount > 0)
      //      {
        //        ndMID.Leaf = false;
          //      //ndMID.Children.Add(ndSeries0);
            //    ndMID.Expanded = true;
           // }
        //    else
          //  {
            //    ndMID.Leaf = true;
          //  }


            ndRoot.Children.Add(ndMID);
                  
      //      nd.Children.Add(ndMID);
              
        }//instrument loop from combo


        //render the tree
        //tpnlSite.Render(tpnlSite, RenderMode.Replace);
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            btnPIExport.Disable();

            //clear the root
            if (tpnlSite1.Root != null)
            {
                if (tpnlSite1.Root.Count > 0)
                {
                    tpnlSite1.Root.Clear();
                }
            }

            //add a new root
            Ext.Net.Node ndRoot1;
            ndRoot1 = new Node() { Text = "" };
            ndRoot1.Expanded = true;
            ndRoot1.EmptyChildren = true;
            tpnlSite1.Root.Add(ndRoot1);

            //clear the root
            if (tpnlSite2.Root != null)
            {
                if (tpnlSite2.Root.Count > 0)
                {
                    tpnlSite2.Root.Clear();
                }
            }

            //add a new root
            Ext.Net.Node ndRoot2;
            ndRoot2 = new Node() { Text = "" };
            ndRoot2.Expanded = true;
            ndRoot2.EmptyChildren = true;
            tpnlSite2.Root.Add(ndRoot2);


            //this page closes the patient
            Master.ClosePatient();

            //load data
            LoadPrograms();
            LoadImpairments();
            LoadInjuries();
            LoadGender();
            LoadDutyStatus();
            LoadSites();
            LoadInstruments();

            //select all clinical settings as default
            Ext.Net.ListItem li = new Ext.Net.ListItem();
            li.Value = "-1";
            li.Mode = ParameterMode.Raw;
            cboReportClinicalSetting.SelectedItems.Add(li);
            cboReportClinicalSetting.UpdateSelectedItems();

            //select all gender setting as default
            Ext.Net.ListItem li2 = new Ext.Net.ListItem();
            li2.Value = "-1";
            li2.Mode = ParameterMode.Raw;
            cboReportGender.SelectedItems.Add(li2);
            cboReportGender.UpdateSelectedItems();


        }
    }

    /// <summary>
    /// load duty status
    /// </summary>
    protected void LoadDutyStatus()
    {
        //load the duty status
        CStat stat = new CStat(Master);
        DataSet dsDutyStatus = stat.GetDataCollectionDS("_DUTY_STATUS");
        //clear the combo
        cboReportMilStatus.GetStore().RemoveAll();
        cboReportMilStatus.Items.Clear();
        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        string strDSJSON = cdc.GetJsonDSString(dsDutyStatus);

        //add All to the json
        string strAll =  "{\"COLLECTION_TYPE\":\"_DUTY_STATUS\",\"COLLECTION_ITEM_ID\":-1.0,\"ITEM\":\"All\",\"ITEM_TYPE\":\"STRING\",\"ALTERNATE_LANGUAGE\":\"Veteran\",\"PLACEHOLDER2\":\"\",\"PLACEHOLDER3\":\"\",\"PLACEHOLDER4\":\"\",\"ACTIVE\":1.0,\"LANGUAGE_ID\":1.0}";
            
        strDSJSON = strDSJSON.Replace("{\"Tables\":[{\"Rows\":[",
                                  "{\"Tables\":[{\"Rows\":[" + strAll + ",");

        
        storMilStatus.SetDataFromJson(strDSJSON);

        //select it
        Ext.Net.ListItem itmAll = new Ext.Net.ListItem();
        itmAll.Value = "-1";
        itmAll.Text = "All";
        cboReportMilStatus.SelectedItems.Add(itmAll);
        cboReportMilStatus.UpdateSelectedItems();
    }

    /// <summary>
    /// load the site multi combo
    /// </summary>
    protected void LoadSites()
    {
        CRegionSite site = new CRegionSite(Master);
        DataSet ds = site.GetSiteDS();
        
        //clear the combo
        cboPISite1.GetStore().RemoveAll();
        cboPISite1.Items.Clear();
        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        string strJSON = cdc.GetJsonDSString(ds);
        storPISite1.SetDataFromJson(strJSON);

        //default site one to the site user is logged into
        cboPISite1.SelectedItems.Clear();
        Ext.Net.ListItem itmSelSite1 = new Ext.Net.ListItem();
        itmSelSite1.Value = Convert.ToString(Master.SiteID);
        itmSelSite1.Mode = ParameterMode.Raw;
        cboPISite1.SelectedItems.Add(itmSelSite1);
        cboPISite1.UpdateSelectedItems();
                
        //clear the combo
        cboPISite2.GetStore().RemoveAll();
        cboPISite2.Items.Clear();
        //load the store from the ds
        strJSON = cdc.GetJsonDSString(ds);

        //add an None and All to the json
        string strEmpty = "{\"REGION_ID\":-99.0,\"SITE_ID\":-99.0,\"SITE_NAME\":\"None\",\"XFER_SYSTEM_ID\":1.0,\"XFER_DATE\":\"\",\"SRV\":\"\",\"PORT\":\"\",\"REGION_NAME\":\"\"}";
        string strAll = "{\"REGION_ID\":-1.0,\"SITE_ID\":-1.0,\"SITE_NAME\":\"All\",\"XFER_SYSTEM_ID\":1.0,\"XFER_DATE\":\"\",\"SRV\":\"\",\"PORT\":\"\",\"REGION_NAME\":\"\"}";
        strJSON = strJSON.Replace("{\"Tables\":[{\"Rows\":[",
                                  "{\"Tables\":[{\"Rows\":[" + strEmpty + "," + strAll + ",");

        storPISite2.SetDataFromJson(strJSON);

        //select none
        Ext.Net.ListItem li = new Ext.Net.ListItem();
        li.Value = "-99";
        li.Mode = ParameterMode.Raw;
        cboPISite2.SelectedItems.Add(li);
        cboPISite2.UpdateSelectedItems();
    }

    /// <summary>
    /// load the instruments multi combo
    /// </summary>
    protected void LoadInstruments()
    {
        CIntake intake = new CIntake(Master);
        DataSet ds = intake.GetAllScorableModuleDS(Master);

        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        string strJSON = cdc.GetJsonDSString(ds);
        storInstruments.SetDataFromJson(strJSON);
    }

    /// <summary>
    /// load injuries dropdownlist
    /// </summary>
    protected void LoadGender()
    {
        //load the gender
      /*  CStat stat = new CStat(Master);
        DataSet dsGender = stat.GetDataCollectionDS("_GENDER");
        //clear the combo
        cboReportGender.GetStore().RemoveAll();
        cboReportGender.Items.Clear();
        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        string strGenJSON = cdc.GetJsonDSString(dsGender);
        storGender.SetDataFromJson(strGenJSON);

        //add an all and select it
        Ext.Net.ListItem itm = new Ext.Net.ListItem();
        itm.Value = "-1";
        itm.Mode = ParameterMode.Raw;
        itm.Text = "All";
        cboReportGender.Items.Insert(0, itm);*/
        //cboReportGender.SelectedItems.Add("-1");
        //cboReportGender.UpdateSelectedItems();
    }


    /// <summary>
    /// load injuries dropdownlist
    /// </summary>
    protected void LoadInjuries()
    {
        //load the impairment
        CReports rep = new CReports();
        //laod the injuries
        DataSet dsInj = rep.GetInjuryDS(Master);
        //clear the combo
        cboReportInjury.GetStore().RemoveAll();
        cboReportInjury.Items.Clear();
        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        string strInjJSON = cdc.GetJsonDSString(dsInj);

        //add All to the json
        string strAll = "{\"RID\":-1.0,\"MID\":-1.0,\"TID\":-1.0,\"QID\":-1.0,\"RESPONSE\":\"All\",\"DISPLAY_TYPE\":1.0,\"RESPONSE_TYPE\":1.0,\"ACTIVE\":1.0,\"UNIT\":\"\",\"MAXLENGTH\":null,\"MASK\":\"\",\"SKIP_SHOW\":\"\",\"SKIP_HIDE\":\"&#39;TID1_QID2&#39;\",\"LABEL_POS\":1.0,\"RESPONSE_GROUP\":1.0,\"SCORE_VALUE\":\"\",\"STAT_LOAD_TABLE\":\"\",\"STAT_LOAD_FIELD\":\"\",\"STAT_LOAD_FILTER\":\"\",\"STAT_LOAD_TABLE_ID\":\"\",\"IDENTIFIER\":\"R10\",\"CDE_ID\":\"\"}";

        strInjJSON = strInjJSON.Replace("{\"Tables\":[{\"Rows\":[",
                                  "{\"Tables\":[{\"Rows\":[" + strAll + ",");


        storInjury.SetDataFromJson(strInjJSON);

        //select it
        Ext.Net.ListItem itmAll = new Ext.Net.ListItem();
        itmAll.Value = "-1";
        itmAll.Text = "All";
        cboReportInjury.SelectedItems.Add(itmAll);
        cboReportInjury.UpdateSelectedItems();


    }

    /// <summary>
    /// load impairments dropdownlist
    /// </summary>
    protected void LoadImpairments()
    {
        //load the impairment
        CReports rep = new CReports();
        DataSet dsImp = rep.GetImpairmentDS(Master);
        //clear the combo
        cboReportImpairment.GetStore().RemoveAll();
        cboReportImpairment.Items.Clear();
        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        string strImpJSON = cdc.GetJsonDSString(dsImp);
        
        //add All to the json
        string strAll = "{\"RID\":-1.0,\"MID\":-1.0,\"TID\":-1.0,\"QID\":-1.0,\"RESPONSE\":\"All\",\"DISPLAY_TYPE\":1.0,\"RESPONSE_TYPE\":1.0,\"ACTIVE\":1.0,\"UNIT\":\"\",\"MAXLENGTH\":null,\"MASK\":\"\",\"SKIP_SHOW\":\"\",\"SKIP_HIDE\":\"&#39;TID1_QID2&#39;\",\"LABEL_POS\":1.0,\"RESPONSE_GROUP\":1.0,\"SCORE_VALUE\":\"\",\"STAT_LOAD_TABLE\":\"\",\"STAT_LOAD_FIELD\":\"\",\"STAT_LOAD_FILTER\":\"\",\"STAT_LOAD_TABLE_ID\":\"\",\"IDENTIFIER\":\"R10\",\"CDE_ID\":\"\"}";
                
        strImpJSON = strImpJSON.Replace("{\"Tables\":[{\"Rows\":[",
                                  "{\"Tables\":[{\"Rows\":[" + strAll + ",");


        storImpairment.SetDataFromJson(strImpJSON);

        //select it
        Ext.Net.ListItem itmAll = new Ext.Net.ListItem();
        itmAll.Value = "-1";
        itmAll.Text = "All";
        cboReportImpairment.SelectedItems.Add(itmAll);
        cboReportImpairment.UpdateSelectedItems();

    }


    /// <summary>
    /// load programs dropdownlist
    /// </summary>
    protected void LoadPrograms()
    {
        CCPA cpa = new CCPA();
        DataSet ds = cpa.GetCPATypeDS(Master);

        //data converter
        CDataConverter cdc = new CDataConverter();
        string strJSON = cdc.GetJsonDSString(ds);

        //add All to the json
        string strAll = "{\"CPA_TYPE_ID\":-1.0,\"CPA_TYPE_TITLE\":\"All\",\"CPA_TYPE_DESCR\":\"\",\"SORT_ORDER\":99.0}";
        strJSON = strJSON.Replace("{\"Tables\":[{\"Rows\":[",
                                  "{\"Tables\":[{\"Rows\":[" + strAll + ",");


        storPICPAType.SetDataFromJson(strJSON);

        Ext.Net.ListItem itmAll = new Ext.Net.ListItem();
        itmAll.Value = "-1";
        itmAll.Text = "All";
        cboPICPAType.SelectedItems.Add(itmAll);
        cboPICPAType.UpdateSelectedItems();


    }
}